-- Adminer 4.7.0 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `udf_categories`;
CREATE TABLE `udf_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL,
  `cat_name` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `udf_categories` (`id`, `cat_id`, `cat_name`) VALUES
(1,	1,	NULL),
(2,	2,	'straat'),
(3,	3,	NULL),
(4,	4,	'sexe'),
(5,	5,	NULL),
(6,	6,	'postcode'),
(7,	7,	'telefoon'),
(8,	8,	'voornaam'),
(9,	9,	NULL),
(10,	10,	'achternaam'),
(11,	11,	'e-mail'),
(12,	12,	NULL),
(13,	13,	NULL),
(14,	14,	NULL),
(15,	15,	NULL);

DROP VIEW IF EXISTS `udf_cat_names`;
CREATE TABLE `udf_cat_names` (`cid` int(11), `cname` varchar(100));


DROP VIEW IF EXISTS `udf_concat`;
CREATE TABLE `udf_concat` (`request` int(11), `id` text, `value` text);


DROP VIEW IF EXISTS `udf_request`;
CREATE TABLE `udf_request` (`udf_id` int(11), `request` text, `value` text);


DROP VIEW IF EXISTS `udf_select_id`;
CREATE TABLE `udf_select_id` (`id` int(11), `udf_id` int(11), `request_id` int(11), `udf_value` varchar(25));


DROP TABLE IF EXISTS `udf_tabel`;
CREATE TABLE `udf_tabel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `udf_id` int(11) NOT NULL,
  `request_id` int(11) NOT NULL,
  `udf_value` varchar(25) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `udf_id` (`udf_id`),
  KEY `request_id` (`request_id`),
  KEY `udf_value` (`udf_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

INSERT INTO `udf_tabel` (`id`, `udf_id`, `request_id`, `udf_value`) VALUES
(40,	10,	12,	'Jansen'),
(41,	5,	12,	'Roermond'),
(42,	11,	12,	'test2@test.com'),
(43,	4,	12,	'V'),
(44,	8,	12,	'Sophie'),
(45,	2,	12,	'Brugstraat 10'),
(46,	6,	12,	'6044 VL'),
(47,	7,	12,	'0639368794'),
(48,	10,	13,	'Ergin'),
(49,	5,	13,	'Zoutewelle'),
(50,	4,	13,	'V'),
(51,	8,	13,	'Camille'),
(52,	2,	13,	'Bolsterstraat 45'),
(53,	6,	13,	'8962 FG'),
(54,	7,	13,	'0234896756'),
(55,	10,	14,	'Cornelissen'),
(56,	5,	14,	'Zierikzee'),
(57,	4,	14,	'M'),
(58,	8,	14,	'Johan'),
(59,	2,	14,	'Paternosterstraat 3'),
(60,	6,	14,	'4301 KP'),
(61,	7,	14,	'0111414433');

DROP TABLE IF EXISTS `udf_cat_names`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `udf_cat_names` AS select `udf_categories`.`cat_id` AS `cid`,concat(ucase(substr(`udf_categories`.`cat_name`,1,1)),substr(`udf_categories`.`cat_name`,2)) AS `cname` from `udf_categories` where (`udf_categories`.`cat_name` is not null);

DROP TABLE IF EXISTS `udf_concat`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `udf_concat` AS select `udf_tabel`.`request_id` AS `request`,group_concat(`udf_tabel`.`udf_id` separator ',') AS `id`,group_concat(`udf_tabel`.`udf_value` separator ',') AS `value` from `udf_tabel` group by `udf_tabel`.`request_id`;

DROP TABLE IF EXISTS `udf_request`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `udf_request` AS select `udf_tabel`.`udf_id` AS `udf_id`,group_concat(`udf_tabel`.`request_id` separator '|') AS `request`,group_concat(`udf_tabel`.`udf_value` separator '|') AS `value` from `udf_tabel` where ((`udf_tabel`.`udf_value` like '%Vrouw%') or (`udf_tabel`.`udf_value` like '%tel%') or (`udf_tabel`.`udf_value` like '%add%')) group by `udf_tabel`.`udf_id`;

DROP TABLE IF EXISTS `udf_select_id`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `udf_select_id` AS select `udf_tabel`.`id` AS `id`,`udf_tabel`.`udf_id` AS `udf_id`,`udf_tabel`.`request_id` AS `request_id`,`udf_tabel`.`udf_value` AS `udf_value` from `udf_tabel` where (`udf_tabel`.`udf_id` in (2,4,7)) order by `udf_tabel`.`udf_id` limit 50;

-- 2019-01-12 11:31:08